function JReportDialog(owner, parent, name, caption, action, method, rect, previous)
{
	var self = this,
		_rendered = false,
		_disposed = false;

	this.initialize(owner, parent, name, caption, action, rect);

	this.isForm   = true;
	this.method   = method;
	this.previous = previous;
	this.methods  = (cmRender | cmLoad);

	this.local    = null;
	this.ids      = [];
	this.combo    = null;
	this.confirm  = null;
	this.cancel   = null;

	this.owner.addImage("close-icon", "close.gif", "form");
	this.rect.normalize(this.owner.getDocument().body);
	this.owner.activeForm = this;

	this.render = render;
	this.load   = load;
	this.close  = close;
	this.isRendered = isRendered;
	this.dispose = dispose;

	function render(fs)
	{
		if (_rendered)
			return;

		var rectConfirm = utils.format("%1;%2;%3;%4", self.rect.width - 155, self.rect.height - 60, 60, 24);
		var rectCancel  = utils.format("%1;%2;%3;%4", self.rect.width -  85, self.rect.height - 60, 60, 24);
		var previous    = self.owner.getObject(self.previous);

		if ((self.confirm == null) && (self.cancel == null))
		{
			self.confirm = self.owner.registerObject(self.name + "_confirm", new JButton(self.owner, self.name, self.name + "_confirm", self.owner.localize("capOK"),     true, rectConfirm, raCloseParent, null));
			self.cancel  = self.owner.registerObject(self.name + "_cancel",  new JButton(self.owner, self.name, self.name + "_cancel",  self.owner.localize("capCancel"), true, rectCancel,  raCloseParent, null));
			self.addControl(self.confirm);
			self.addControl(self.cancel);
		}

		if (self.local == null)
		{
			var items = [];
			var list  = previous.reports.split(";");
			var pair  = null;

			list.forEach( function(item, i) 
			{
				pair                        = item.split("=");
				self.ids[self.ids.length++] = pair[0];
				items[items.length++]       = (items.length - 1) + "=" + pair[1];
			}, self);

			self.local = self.owner.registerObject(self.name + "_local", new JDataset(self.owner, self.name, self.name + "_local", "", "", dfNone));
			self.local.addField(new JField("rep", "", ftEnum, items.join(";"), ffRequired));
			self.local.loadRecord("add", "", "rep=0%17", rsUnchanged, rfNone, true);
		}

		if (self.combo == null)
		{
			var label = self.owner.registerObject(self.name + "_lab_1", new JLabel(self.owner, self.name, self.name + "_lab_1", null, null, self.owner.localize("capReport"), laLeft, "10;22;60;21", null));
			self.combo = self.owner.registerObject(self.name + "_combo", new JEnumPicker(self.owner, self.name, self.name + "_combo", self.local, "rep", "75;15;250;21", null));
			self.addControl(label);
			self.addControl(self.combo);
		}

		fs.append( '<div class="dialogForm" id="' + self.name + '" style="' + self.rect + '">');
		fs.append('  <div id="' + self.name + '_title" class="form_titlebar">');
		fs.append('    <span id="' + self.name + '_caption" class="form_caption">' + self.caption + '</span>');
		fs.append('  </div>');

		fs.append(   '<div class="dialogForm_inlet" id="' + self.name + '_inlet" style="top: ' + (fmDragbarHeight + fmBorderWidth) + 'px; height: ' + (self.rect.height - fmDragbarHeight - 3 * fmBorderWidth) + 'px; width: ' + (self.rect.width - 2 * fmBorderWidth) + 'px">');

		self.controls.forEach (function (control)
		{
			if (utils.inSet(cmRender, control.methods))
			{
				control.render(fs);
			}
		}, self);

		fs.append(   "</div>");
		fs.append( "</div>");

		_rendered = true;
	}

	function load()
	{
		self.owner.getDocument().body.appendChild(self.$$());

		self.controls.forEach (function (control)
		{
			if (utils.inSet(cmLoad, control.methods))
				control.load();
		}, self);

		self.owner.splash(true);
		self.owner.setSplashInfo('');
	}

	function close(e)
	{
		self.owner.splash(false);
		self.$$().style.display = 'none';

		var element = utils.getEventElement(e);
		
		while (element.className != "button")
		{
			element = element.parentNode;
		}

		self.$$().style.borderStyle = "outset";
		if (element.id == self.name + "_confirm")
		{
			var afmobj = self.owner.getObject(self.owner.activeForm);
			var pfmobj = self.owner.getObject(self.previous);

			var query  = new Postback(raPrintReport);
			query.set("rid", self.ids[self.local.get("rep")]);
			query.set("pfm", pfmobj.name);
			query.set("pds", pfmobj.dataset.name);
			query.set("rec", pfmobj.dataset.getCurrentRecord().key);

			self.owner.post(raPrintReport, query);
		}

		self.owner.unregisterObject(self.name);
	}

	function isRendered()
	{
	  return _rendered;
	}

	function dispose()
	{
		if (_disposed)
			return;

		self.owner.unregisterObject(self.name + "_confirm");
		self.owner.unregisterObject(self.name + "_cancel");

		self.disposeChildren();
		self.local.dispose();
		self.local = null;

		if (self.$$().parentNode != null)
			self.$$().parentNode.removeChild(self.$$());

		self.base.dispose.call(self);
		_disposed = true;
	}
}

JReportDialog.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();